import { NextIntlClientProvider } from 'next-intl';
import { getMessages } from 'next-intl/server';
import { notFound } from 'next/navigation';
import { routing } from '@/i18n/routing';
import StoreProvider from "@/lib/store/StoreProvider";
import { Alexandria, Almarai } from "next/font/google";
import "../globals.css";
import { Header } from '@/components';
import { Footer } from '@/components/layout/Footer';

export function generateStaticParams() {
  return routing.locales.map((locale) => ({ locale }));
}

const alexandria = Alexandria({
  subsets: ["arabic", "latin"],
  weight: ["100", "200", "300", "400", "500", "700", "800", "900"],
  variable: "--font-alexandria",
});

const almarai = Almarai({
  subsets: ["arabic", "latin"],
  weight: ["300", "400", "700", "800"],
  variable: "--font-Almarai",
});

export default async function LocaleLayout({
  children,
  params
}: {
  children: React.ReactNode;
  params: Promise<{ locale: string }>;
}) {
  const { locale } = await params;

  if (!routing.locales.includes(locale as any)) {
    notFound();
  }

  const messages = await getMessages({ locale });
  const dir = locale === 'ar' ? 'rtl' : 'ltr';

  return (
    <html lang={locale} dir={dir} className="h-full scroll-smooth">
      <body className={`${alexandria.variable} ${almarai.variable} h-full antialiased font-alexandria`}>
        <NextIntlClientProvider locale={locale} messages={messages}>
          <StoreProvider>
            <div className="flex flex-col min-h-screen">
              <Header />
              
              <main className="flex-1 w-full z-10">
                {children}
              </main>

              <Footer />
            </div>
          </StoreProvider>
        </NextIntlClientProvider>
      </body>
    </html>
  );
}